# Dashboard Extras Module

[![Latest Version](https://img.shields.io/github/release/studiobonito/silverstripe-dashboard-extras.svg?style=flat-square)](https://github.com/studiobonito/silverstripe-dashboard-extras/releases)
[![Software License](https://img.shields.io/badge/license-BSD-brightgreen.svg?style=flat-square)](LICENSE.md)
[![Build Status](https://img.shields.io/travis/studiobonito/silverstripe-dashboard-extras/master.svg?style=flat-square)](https://scrutinizer-ci.com/g/studiobonito/silverstripe-dashboard-extras/build-status/master)
[![Coverage Status](https://img.shields.io/scrutinizer/coverage/g/studiobonito/silverstripe-dashboard-extras.svg?style=flat-square)](https://scrutinizer-ci.com/g/studiobonito/silverstripe-dashboard-extras/code-structure)
[![Quality Score](https://img.shields.io/scrutinizer/g/studiobonito/silverstripe-dashboard-extras.svg?style=flat-square)](https://scrutinizer-ci.com/g/studiobonito/silverstripe-dashboard-extras)
[![Total Downloads](https://img.shields.io/packagist/dt/studiobonito/silverstripe-dashboard-extras.svg?style=flat-square)](https://packagist.org/packages/studiobonito/silverstripe-dashboard-extras)

## Overview

Provide some extra configuration options and panels for the SilverStripe Dashboard Module.

### Current Features

- New members chart panel
- YAML based configuration for Google Analytics account details

## Requirements

- SilverStripe 3.1 or newer.
- SilverStripe Dashboard Module 1.0.0 or newer.

## Install

### Via Composer

``` bash
$ composer require studiobonito/silverstripe-dashboard-extras
```

### Manually

Copy the 'silverstripe-dashboard-extras' folder to the root of your SilverStripe installation.

## Usage

To configure the Google account details for the Google Analytics panel create the file `mysite/_config/google-analytics.yml` and
insert the following:

``` yml
---
Name: google-analytics
---
GoogleAnalytics:
  AccountEmail: 'analytics@example.co.uk'
  AccountPassword: 'abcDEF1234ghi456JKL'
```

## Testing

``` bash
$ phpunit
```

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security

If you discover any security related issues, please email support@studiobonito.co.uk instead of using the issue tracker.

## Credits

- [Tom Densham](https://github.com/nedmas)
- [All Contributors](../../contributors)

## License

The BSD-2-Clause License. Please see [License File](LICENSE.md) for more information.