<?php namespace StudioBonito\SilverStripe\Dashboard\Extensions;

use Config;
use DashboardGoogleAnalyticsPanel;
use SiteConfig;

/**
 * GoogleAnalyticsDashboardExtension.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class GoogleAnalyticsDashboardExtension extends \Extension
{
    /**
     * @codeCoverageIgnore
     */
    public function init()
    {
        $config = Config::inst();
        $siteConfig = SiteConfig::current_site_config();

        $googleAnalyticsViewID = $siteConfig->GoogleAnalyticsViewID ?: $config->get('GoogleAnalytics', 'ViewID');

        DashboardGoogleAnalyticsPanel::set_account(
            Config::inst()->get('GoogleAnalytics', 'AccountEmail'),
            Config::inst()->get('GoogleAnalytics', 'AccountPassword'),
            $googleAnalyticsViewID
        );
    }
} 