<?php namespace StudioBonito\SilverStripe\Dashboard;

use DashboardChart;
use DB;
use DropdownField;

/**
 * DashboardNewMembersPanel.
 *
 * @property string $DateFormat
 * @property string $DateRange
 * @property string $Label
 * @property string $Description
 * @property int    $StartDateStamp
 * @property string $DateFormatString
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class DashboardNewMembersPanel extends \DashboardPanel
{
    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = array(
        'DateFormat' => "Enum('mdy,dmy','dmy')",
        'DateRange'  => "Enum('day,week,month,year','month')",
    );

    /**
     * @var string The name of the template used for the contents of this panel.
     */
    protected $template = 'DashboardNewMembersPanel';

    /**
     * Provide a title to the panel selection window.
     *
     * @return string
     */
    public function getLabel()
    {
        return _t('DashboardExtras.NEWMEMBERS', 'New Members');
    }

    /**
     * Provide a description to the panel selection window.
     *
     * @return string
     */
    public function getDescription()
    {
        return _t('DashboardExtras.NEWMEMBERS_DESC', 'Displays a chart of new members');
    }

    /**
     * Gets the {@link FieldList} object that is used to configure the fields on this panel.
     * Similar to getCMSFields().
     *
     * @return \FieldList
     */
    public function getConfiguration()
    {
        $fields = parent::getConfiguration();

        $fields->push(DropdownField::create("DateFormat", _t('Dashboard.DATEFORMAT', 'Date format'), array(
            'dmy' => date('j M, Y'),
            'mdy' => date('M j, Y')
        ))
            ->addExtraClass('no-chzn')
        );
        $fields->push(DropdownField::create("DateRange", _t('Dashboard.DATERANGE', 'Date range'), array(
            'day'   => _t('Dashboard.TODAY', 'Today'),
            'week'  => _t('Dashboard.PREVIOUSSEVENDAYS', '7 days'),
            'month' => _t('Dashboard.PREVIOUSTHIRTYDAYS', '30 days'),
            'year'  => _t('Dashboard.PREVIOUSYEAR', '365 days')
        ))
            ->addExtraClass('no-chzn')
        );

        return $fields;
    }

    /**
     * Gets a timestamp for the start date of reporting, based on user provided data.
     *
     * @return int
     */
    public function getStartDateStamp()
    {
        switch ($this->DateRange) {
            case "day":
                return time();
            case "week":
                return strtotime("-7 days");
            case "month":
                return strtotime("-30 days");
            case "year":
                return strtotime("-1 year");
            default:
                return strtotime("-30 days");
        }
    }

    /**
     * Gets a format string for date time.
     *
     * @return string
     */
    public function getDateFormatString()
    {
        switch ($this->DateFormat) {
            case 'mdy':
                return 'M j, Y';
            default:
                return 'j M, Y';
        }
    }

    /**
     * Create a Google chart showing new members.
     *
     * @return \DashboardChart
     */
    public function Chart()
    {
        $fromDate = date($this->DateFormatString, $this->StartDateStamp);
        $toDate = date($this->DateFormatString);

        $chart = DashboardChart::create("{$fromDate} - {$toDate}", "Date", "Number of new members");

        $startDate = date('Y-m-d H:i:s', $this->getStartDateStamp());

        $query = "SELECT COUNT(*) AS MemberCount, DATE_FORMAT(Created,'%d %b %Y') AS Date FROM \"Member\""
            . " WHERE \"Created\" > '{$startDate}' GROUP BY Date";

        $result = DB::query($query);
        if ($result) {
            while ($row = $result->nextRecord()) {
                $chart->addData($row['Date'], $row['MemberCount']);
            }
        }

        return $chart;
    }
}