<?php namespace StudioBonito\SilverStripe\Dashboard\Extensions;

use FieldList;
use TextField;

/**
 * Update SiteConfig fields to include Google Analytics view ID field.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class GoogleAnalyticsSiteConfigExtension extends \DataExtension
{
    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = array(
        'GoogleAnalyticsViewID' => 'Varchar(16)',
    );

    /**
     * Update list of fields in SiteConfig. Adds all fields to inside `Services` parent tab.
     *
     * @param FieldList $fields
     */
    public function updateCMSFields(FieldList $fields)
    {
        $fields->addFieldsToTab(
            'Root.Services.GoogleAnalytics',
            array(
                $viewIdTextField = new TextField(
                    'GoogleAnalyticsViewID',
                    _t('GoogleAnalytics.VIEWID', 'Google Analytics View ID')
                )
            )
        );

        $viewIdTextField->setDescription(_t('GoogleAnalytics.VIEWID_DESC', 'e.g. \'12345678\''));
    }
}