<?php namespace StudioBonito\SilverStripe\Teams\Models;

use CheckboxField;
use Controller;
use FieldList;
use GridField;
use GridFieldConfig_RelationEditor;
use Permission;
use ToggleCompositeField;

/**
 * TeamPage stores a list of TeamPage Members.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class TeamPage extends \Page implements \PermissionProvider
{
    /**
     * Human-readable singular name. See {@link DataObject::$singular_name}
     *
     * @var string
     */
    public static $singular_name = 'Team List';

    /**
     * Human-readable pluaral name. See {@link DataObject::$plural_name}
     *
     * @var string
     */
    public static $plural_name = 'Team Lists';

    public static $icon = 'teams/images/team.png';

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @access public
     * @static
     * @var array
     */
    public static $db = array(
        'ShowName'            => 'Boolean',
        'ShowRole'            => 'Boolean',
        'ShowDescription'     => 'Boolean',
        'ShowPicture'         => 'Boolean',
        'ShowEmail'           => 'Boolean',
        'ShowLinkedin'        => 'Boolean',
        'ShowFacebook'        => 'Boolean',
        'ShowTwitter'         => 'Boolean',
        'ShowPersonalWebsite' => 'Boolean',
    );

    /**
     * List of many-to-many relationships. {@link DataObject::$many_many}
     *
     * @access public
     * @static
     * @var array
     */
    public static $many_many = array(
        'Members' => 'StudioBonito\SilverStripe\Teams\Models\TeamMember',
    );

    public static $many_many_extraFields = array(
        'Members' => array(
            'Sort' => 'Int',
        ),
    );

    public static $defaults = array(
        'ShowName'            => true,
        'ShowRole'            => false,
        'ShowDescription'     => true,
        'ShowPicture'         => true,
        'ShowEmail'           => true,
        'ShowLinkedin'        => false,
        'ShowFacebook'        => false,
        'ShowTwitter'         => false,
        'ShowPersonalWebsite' => false,
    );

    public static $summary_fields = array(
        'Title',
    );

    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        $gridFieldConfig = GridFieldConfig_RelationEditor::create();

        if (class_exists('GridFieldAddExistingSearchButton')) {
            $gridFieldConfig->removeComponentsByType('GridFieldAddExistingAutocompleter');
            $gridFieldConfig->addComponent(new \GridFieldAddExistingSearchButton());
        }

        if (class_exists('GridFieldOrderableRows')) {
            $gridFieldConfig->addComponent(new \GridFieldOrderableRows('Sort'));
        }

        $fields->addFieldToTab(
            'Root.TeamMembers',
            new GridField('Members', _t('TEAMS.Members', 'Team Members'), $this->owner->Members(), $gridFieldConfig)
        );

        $displaySettings = new ToggleCompositeField('DisplaySettings', 'Display Settings', new FieldList(
            new CheckboxField('ShowName', _t('TeamPage.SHOW_NAME', 'Show Name?')),
            new CheckboxField('ShowRole', _t('TeamPage.SHOW_ROLE', 'Show Role?')),
            new CheckboxField('ShowDescription', _t('TeamPage.SHOW_DESCRIPTION', 'Show Description?')),
            new CheckboxField('ShowPicture', _t('TeamPage.SHOW_PICTURE', 'Show Picture?')),
            new CheckboxField('ShowEmail', _t('TeamPage.SHOW_EMAIL', 'Show Email?')),
            new CheckboxField('ShowLinkedin', _t('TeamPage.SHOW_LINKEDIN', 'Show Linkedin?')),
            new CheckboxField('ShowFacebook', _t('TeamPage.SHOW_FACEBOOK', 'Show Facebook?')),
            new CheckboxField('ShowTwitter', _t('TeamPage.SHOW_TWITTER', 'Show Twitter?')),
            new CheckboxField('ShowPersonalWebsite', _t('TeamPage.SHOW_PERSONALWEBSITE', 'Show Personal Website?'))
        ));

        $fields->addFieldToTab('Root.TeamMembers', $displaySettings);

        return $fields;
    }

    public function getMembers()
    {
        return $this->getManyManyComponents('Members')->sort('Sort');
    }

    public function Members()
    {
        return $this->getMembers();
    }

    public function providePermissions()
    {
        return array(
            'CREATE_TEAM' => array(
                'name'     => _t('Teams.CREATE_TEAM_DESCRIPTION', 'Create a new Team'),
                'category' => _t('Teams.TEAM_PERMISSIONS_CATEGORY', 'Global Team permissions'),
                'sort'     => -80,
                //'help' => TODO: Add help text
            ),
            'DELETE_TEAM' => array(
                'name'     => _t('Teams.DELETE_TEAM_DESCRIPTION', 'Delete any Team'),
                'category' => _t('Teams.TEAM_PERMISSIONS_CATEGORY', 'Global Team permissions'),
                'sort'     => -80,
                //'help' => TODO: Add help text
            ),
            'EDIT_TEAM'   => array(
                'name'     => _t('Teams.EDIT_TEAM_DESCRIPTION', 'Edit any Team'),
                'category' => _t('Teams.TEAM_PERMISSIONS_CATEGORY', 'Global Team permissions'),
                'sort'     => -80,
                //'help' => TODO: Add help text
            ),
            'VIEW_TEAM'   => array(
                'name'     => _t('Teams.VIEW_TEAM_DESCRIPTION', 'View any Team'),
                'category' => _t('Teams.TEAM_PERMISSIONS_CATEGORY', 'Global Team permissions'),
                'sort'     => -80,
                //'help' => TODO: Add help text
            ),
        );
    }

    public function canCreate($member = null)
    {
        $context = func_num_args() > 1 ? func_get_arg(1) : array();

        return parent::canCreate($member, $context) && Permission::check('CREATE_TEAM', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return parent::canDelete($member) && Permission::check('DELETE_TEAM', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return parent::canEdit($member) && Permission::check('EDIT_TEAM', 'any', $member);
    }

    public function canView($member = null)
    {
        return parent::canView($member);
    }
}
