# Teams Module

[![Latest Version](https://img.shields.io/github/release/studiobonito/silverstripe-teams.svg?style=flat-square)](https://github.com/studiobonito/silverstripe-teams/releases)
[![Software License](https://img.shields.io/badge/license-BSD-brightgreen.svg?style=flat-square)](LICENSE.md)
[![Quality Score](https://img.shields.io/scrutinizer/g/studiobonito/silverstripe-teams.svg?style=flat-square)](https://scrutinizer-ci.com/g/studiobonito/silverstripe-teams)
[![Total Downloads](https://img.shields.io/packagist/dt/studiobonito/silverstripe-teams.svg?style=flat-square)](https://packagist.org/packages/studiobonito/silverstripe-teams)

## Overview

The Teams module adds support for creating teams and displaying them on your Silverstripe site.

## Requirements

- SilverStripe 3.1 or newer.

## Install

### Via Composer

``` bash
$ composer require studiobonito/silverstripe-teams
```

### Manually

Copy the 'silverstripe-teams' folder to the root of your SilverStripe installation.

## Usage

### Team Member as child of Team Page

In order to have members appear in the site tree as children of their team page use `TeamMemberAsChildExtension`.

```yaml
StudioBonito\SilverStripe\Teams\Models\TeamPage:
  extensions:
    - StudioBonito\SilverStripe\Teams\Extensions\TeamMemberAsChildExtension
```

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security

If you discover any security related issues, please email support@studiobonito.co.uk instead of using the issue tracker.

## Credits

- [Tom Densham](https://github.com/nedmas)
- [All Contributors](../../contributors)

## License

The BSD-2-Clause License. Please see [License File](LICENSE.md) for more information.