<?php namespace StudioBonito\SilverStripe\Teams\Controllers;

use SS_HTTPRequest;
use StudioBonito\SilverStripe\Teams\Models\TeamMember;

/**
 * Controller for team page.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class TeamPage_Controller extends \Page_Controller
{
    public static $allowed_actions = array(
        'member'
    );

    public function member(SS_HTTPRequest $request)
    {
        $member = TeamMember::get()->filter(array('Name' => $request->param('ID')))->first();

        return $this->render(array('Member' => $member));
    }
}
