<?php

/**
 * TeamHolder stores a list of TeamHolder Members.
 *
 * @author Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright (c) 2012, Studio Bonito Ltd.
 * @version 1.0
 */
class TeamHolder extends Page implements PermissionProvider {

    /**
     * Human-readable singular name. See {@link DataObject::$singular_name}
     * @var string
     */
    public static $singular_name = 'Team List';

    /**
     * Human-readable pluaral name. See {@link DataObject::$plural_name}
     * @var string
     */
    public static $plural_name = 'Team Lists';

    public static $icon = 'teams/images/team.png';

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @access public
     * @static
     * @var array
     */
    public static $db = array(
        'ShowName'            => 'Boolean',
        'ShowRole'            => 'Boolean',
        'ShowDescription'     => 'Boolean',
        'ShowPicture'         => 'Boolean',
        'ShowEmail'           => 'Boolean',
        'ShowLinkedin'        => 'Boolean',
        'ShowFacebook'        => 'Boolean',
        'ShowTwitter'         => 'Boolean',
        'ShowPersonalWebsite' => 'Boolean'
    );

    /**
     * List of many-to-many relationships. {@link DataObject::$many_many}
     *
     * @access public
     * @static
     * @var array
     */
    public static $many_many = array(
        'Members' => 'TeamMember',
    );

    public static $defaults = array(
        'ShowName'            => true,
        'ShowRole'            => false,
        'ShowDescription'     => true,
        'ShowPicture'         => true,
        'ShowEmail'           => true,
        'ShowLinkedin'        => false,
        'ShowFacebook'        => false,
        'ShowTwitter'         => false,
        'ShowPersonalWebsite' => false,
    );

    public static $summary_fields = array(
        'Title'
    );

    public function Children()
    {
        return $this->Members();
    }

    public function isCurrent()
    {
        if (Controller::curr()->getAction() == 'member') {
            return false;
        }

        return parent::isCurrent();
    }

    public function isSection()
    {
        if (Controller::curr()->getAction() == 'member') {
            return true;
        }

        return parent::isSection();
    }

    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        $fields->addFieldToTab('Root.TeamMembers', new GridField('Members', _t('TEAMS.Members', 'Team Members'), $this->owner->Members(), GridFieldConfig_RelationEditor::create()));

        $displaySettings = new ToggleCompositeField('DisplaySettings', 'Display Settings', new FieldList(
            new CheckboxField('ShowName', _t('ShowName', 'Show Name?')),
            new CheckboxField('ShowRole', _t('ShowRole', 'Show Role?')),
            new CheckboxField('ShowDescription', _t('ShowDescription', 'Show Description?')),
            new CheckboxField('ShowPicture', _t('ShowPicture', 'Show Picture?')),
            new CheckboxField('ShowEmail', _t('ShowEmail', 'Show Email?')),
            new CheckboxField('ShowLinkedin', _t('ShowLinkedin', 'Show Linkedin?')),
            new CheckboxField('ShowFacebook', _t('ShowFacebook', 'Show Facebook?')),
            new CheckboxField('ShowTwitter', _t('ShowTwitter', 'Show Twitter?')),
            new CheckboxField('ShowPersonalWebsite', _t('ShowPersonalWebsite', 'Show Personal Website?'))
        ));

        $fields->addFieldToTab('Root.TeamMembers', $displaySettings);

        return $fields;
    }

    public function providePermissions()
    {
        return array(
            'CREATE_TEAM' => array(
                'name'     => _t('TEAMS.CREATE_TEAM_DESCRIPTION', 'Create a new Team'),
                'category' => _t('TEAMS.TEAM_PERMISSIONS_CATEGORY', 'Global Team permissions'),
                'sort'     => -80,
                //'help' => TODO: Add help text
            ),
            'DELETE_TEAM' => array(
                'name'     => _t('TEAMS.DELETE_TEAM_DESCRIPTION', 'Delete any Team'),
                'category' => _t('TEAMS.TEAM_PERMISSIONS_CATEGORY', 'Global Team permissions'),
                'sort'     => -80,
                //'help' => TODO: Add help text
            ),
            'EDIT_TEAM'   => array(
                'name'     => _t('TEAMS.EDIT_TEAM_DESCRIPTION', 'Edit any Team'),
                'category' => _t('TEAMS.TEAM_PERMISSIONS_CATEGORY', 'Global Team permissions'),
                'sort'     => -80,
                //'help' => TODO: Add help text
            ),
            'VIEW_TEAM'   => array(
                'name'     => _t('TEAMS.VIEW_TEAM_DESCRIPTION', 'View any Team'),
                'category' => _t('TEAMS.TEAM_PERMISSIONS_CATEGORY', 'Global Team permissions'),
                'sort'     => -80,
                //'help' => TODO: Add help text
            )
        );
    }

    public function canCreate($member = null)
    {
        return Permission::check('CREATE_TEAM', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('DELETE_TEAM', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('EDIT_TEAM', 'any', $member);
    }

    public function canView($member = null)
    {
        return Permission::check('VIEW_TEAM', 'any', $member);
    }
}

class TeamHolder_Controller extends Page_Controller {

    public static $allowed_actions = array(
        'member'
    );

    public function member(SS_HTTPRequest $request)
    {
        $member = TeamMember::get()->filter(array('Name' => $request->param('ID')))->first();

        return $this->render(array('Member' => $member));
    }
}