<?php

/**
 * Team Admin provides an interface to manage Teams and Team Members.
 *
 * @author Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright (c) 2012, Studio Bonito Ltd.
 * @version 1.0
 */
class TeamAdmin extends ModelAdmin {
    /**
     * The current url segment attached to the LeftAndMain instance
     *
     * @var string
     */
    public static $url_segment = 'teams';

    /**
     * @var string
     */
    public static $menu_title = 'Teams';

    public static $menu_icon = 'teams/images/team.png';

    /**
     * List of DataObjects to manage. {@link ModelAdmin::$managed_models}
     *
     * @var array|string
     */
    public static $managed_models = array(
        'TeamHolder' => array('title' => 'Teams'),
        'TeamMember' => array('title' => 'Team Members')
    );

    /**
     * Enable/Disable import form. {@link ModelAdmin::$showImportForm}
     *
     * @var array|boolean
     */
    public $showImportForm = array(
        'Team'       => false,
        'TeamMember' => false
    );

    public function init()
    {
        parent::init();

        $referer = $this->request->getHeader('Referer');
        $adminLink = $this->Link();

        // Delete the backlink stored in session if the current page is the default view.
        if (substr_compare($referer, $adminLink, -strlen($adminLink), strlen($adminLink)) === 0) {
            Session::clear("{$this->class}Backlink");
        }
    }

    /**
     * Provide a backlink if the user has been redirect from another area of the CMS.
     *
     * @return string|boolean
     */
    public function Backlink()
    {
        $referer = $this->request->getHeader('Referer');
        $xPjax = $this->request->getHeader('X-Pjax');
        $backlink = Session::get("{$this->class}Backlink");

        if (empty($xPjax) && isset($referer)) {
            Session::set("{$this->class}Backlink", $referer);

            return $referer;
        } elseif (isset($referer) && isset($backlink)) {
            return $backlink;
        }

        Session::clear("{$this->class}Backlink");

        return false;
    }
}
