<?php namespace StudioBonito\SilverStripe\Teams\Extensions;

use Controller;

/**
 * Extension to provide team members as children of team page.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class TeamMemberAsChildExtension extends \DataExtension
{
    /**
     * Override child pages with members.
     *
     * @return mixed
     */
    public function Children()
    {
        return $this->owner->Members();
    }

    /**
     * Check if the page is current.
     *
     * @return bool
     */
    public function isCurrent()
    {
        if (Controller::curr()->getAction() === 'member') {
            return false;
        }

        return $this->owner->Parent()->isCurrent();
    }

    /**
     * Check if the page is in the current section.
     *
     * @return bool
     */
    public function isSection()
    {
        if (Controller::curr()->getAction() === 'member') {
            return true;
        }

        return $this->owner->Parent()->isSection();
    }
}
