# URL Segment Module

[![Latest Version](https://img.shields.io/github/release/studiobonito/silverstripe-urlsegment.svg?style=flat-square)](https://github.com/studiobonito/silverstripe-urlsegment/releases)
[![Software License](https://img.shields.io/badge/license-BSD-brightgreen.svg?style=flat-square)](LICENSE.md)
[![Quality Score](https://img.shields.io/scrutinizer/g/studiobonito/silverstripe-urlsegment.svg?style=flat-square)](https://scrutinizer-ci.com/g/studiobonito/silverstripe-urlsegment)
[![Total Downloads](https://img.shields.io/packagist/dt/studiobonito/silverstripe-urlsegment.svg?style=flat-square)](https://packagist.org/packages/studiobonito/silverstripe-urlsegment)

## Overview

Provide URL Segment functions to any DataObject in SilverStripe CMS.

## Requirements

- SilverStripe 3.1 or newer.

## Install

### Via Composer

``` bash
$ composer require studiobonito/silverstripe-urlsegment
```

### Manually

Copy the 'silverstripe-urlsegment' folder to the root of your SilverStripe installation.

## Usage

There are two steps to using the URL Segment module.
Firstly configure your `DataObject` to use the `URLSegmentExtension` extension.

```yml
MyDataObject:
    extensions:
        - StudioBonito\URLSegment\Extensions\URLSegmentExtension
```

Secondly it is necessary for your `DataObject` to have a `Parent` that is a descendant of `SiteTree`.

``` php
private static $has_one = array(
    'Parent' => 'SiteTree',
);
```

## Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for details.

## Security

If you discover any security related issues, please email support@studiobonito.co.uk instead of using the issue tracker.

## Credits

- [Tom Densham](https://github.com/nedmas)
- [All Contributors](../../contributors)

## License

The BSD-2-Clause License. Please see [License File](LICENSE.md) for more information.